(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6720,        170]*)
(*NotebookOutlinePosition[      7560,        197]*)
(*  CellTagsIndexPosition[      7516,        193]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\( (*\ 
      Repeated\ Weddle\ rule\ with\ 12\ intervals\ of\ equal\ length\ 
          \[Pi]/6\ from\ \n\t\t\t - \[Pi]\ to\ \[Pi]\ \ *) \n
    f[t_, \[Tau]_]\  := \ 1/\((0.68\  - \ 0.32*Cos[t + \[Tau]])\); 
    \n (*\ This\ is\ lhs\ of\ Eq\ \((1)\)\ \ *) 
      \(y1 + \((3/200)\)*\ 
            \((\ y1*f[0, \(-\[Pi]\)] + 5\ y2*f[0, \(-5\) \[Pi]/6] + \ \ 
                y3*f[0, \(-2\) \[Pi]/3]\  + 6\ y4*f[0, \(-\[Pi]\)/2] + \ \ 
                y3*f[0, \(-\[Pi]\)/3] + \ 5\ y2*f[0, \(-\[Pi]\)/6] + 
                2\ y1*f[0, 0] + 5\ y2*f[0, \[Pi]/6] + \ y3*f[0, \[Pi]/3] + 
                6\ y4*f[0, \[Pi]/2] + \ y3*f[0, 2  \[Pi]/3] + 
                5\ y2*f[0, 5  \[Pi]/6] + \ y1*f[0, \[Pi]]\ )\) // N\) // 
      Simplify\)\)], "Input"],

Cell[BoxData[
    \(1.11333333333333328`\ y1 + 0.529045643153526867`\ y2 + 
      0.0934065934065933944`\ y3 + 0.264705882352941124`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ This\ is\ lhs\ of\ Eq\ \((2)\)\ \ *) \n
    \(y2 + \((3/200)\)*\ 
            \((\ y1*f[\[Pi]/6, \(-\[Pi]\)] + 
                5\ y2*f[\[Pi]/6, \(-5\) \[Pi]/6] + \ \ 
                y3*f[\[Pi]/6, \(-2\) \[Pi]/3]\  + 
                6\ y4*f[\[Pi]/6, \(-\[Pi]\)/2] + \ \ 
                y3*f[\[Pi]/6, \(-\[Pi]\)/3] + \ 
                5\ y2*f[\[Pi]/6, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/6, 0] + 
                5\ y2*f[\[Pi]/6, \[Pi]/6] + \ y3*f[\[Pi]/6, \[Pi]/3] + 
                6\ y4*f[\[Pi]/6, \[Pi]/2] + \ y3*f[\[Pi]/6, 2  \[Pi]/3] + 
                5\ y2*f[\[Pi]/6, 5  \[Pi]/6] + \ y1*f[\[Pi]/6, \[Pi]]\ )\) // 
        N\) // Simplify\)\)], "Input"],

Cell[BoxData[
    \(0.105809128630705373`\ y1 + 1.51684981684981678`\ y2 + 
      0.0970222113741762193`\ y3 + 0.280219780219780147`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ This\ is\ lhs\ of\ Eq\ \((3)\)\ *) \n\n
    \(y3 + \((3/200)\)*\ 
            \((\ y1*f[\[Pi]/3, \(-\[Pi]\)] + 
                5\ y2*f[\[Pi]/3, \(-5\) \[Pi]/6] + \ \ 
                y3*f[\[Pi]/3, \(-2\) \[Pi]/3]\  + 
                6\ y4*f[\[Pi]/3, \(-\[Pi]\)/2] + \ \ 
                y3*f[\[Pi]/3, \(-\[Pi]\)/3] + \ 
                5\ y2*f[\[Pi]/3, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/3, 0] + 
                5\ y2*f[\[Pi]/3, \[Pi]/6] + \ y3*f[\[Pi]/3, \[Pi]/3] + 
                6\ y4*f[\[Pi]/3, \[Pi]/2] + \ y3*f[\[Pi]/3, 2  \[Pi]/3] + 
                5\ y2*f[\[Pi]/3, 5  \[Pi]/6] + \ y1*f[\[Pi]/3, \[Pi]]\ )\) // 
        N\) // Simplify\)\)], "Input"],

Cell[BoxData[
    \(0.0934065934065933944`\ y1 + 0.485111056870881096`\ y2 + 
      1.1033699633699634`\ y3 + 0.31742738589211612`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ This\ is\ lhs\ of\ Eq\ \((4)\)\ *) \n
    \(y4 + \((3/200)\)*\ 
            \((\ y1*f[\[Pi]/2, \(-\[Pi]\)] + 
                5\ y2*f[\[Pi]/2, \(-5\) \[Pi]/6] + \ \ 
                y3*f[\[Pi]/2, \(-2\) \[Pi]/3]\  + 
                6\ y4*f[\[Pi]/2, \(-\[Pi]\)/2] + \ \ 
                y3*f[\[Pi]/2, \(-\[Pi]\)/3] + \ 
                5\ y2*f[\[Pi]/2, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/2, 0] + 
                5\ y2*f[\[Pi]/2, \[Pi]/6] + \ y3*f[\[Pi]/2, \[Pi]/3] + 
                6\ y4*f[\[Pi]/2, \[Pi]/2] + \ y3*f[\[Pi]/2, 2  \[Pi]/3] + 
                5\ y2*f[\[Pi]/2, 5  \[Pi]/6] + \ y1*f[\[Pi]/2, \[Pi]]\ )\) // 
        N\) // Simplify\)\)], "Input"],

Cell[BoxData[
    \(0.088235294117647065`\ y1 + 0.467032967032966972`\ y2 + 
      0.105809128630705373`\ y3 + 1.33999999999999985`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Now\ to\ solve\ the\ four\ equations\ *) \n
    NSolve[{1.11333333333333328`\ y1 + 0.529045643153526867`\ y2 + 
            0.0934065934065933944`\ y3 + 0.264705882352941124`\ y4 == \ 25, \n
        0.105809128630705373`\ y1 + 1.51684981684981678`\ y2 + 
            0.0970222113741762193`\ y3 + 0.280219780219780147`\ y4 == \ 21, \n
        0.0934065934065933944`\ y1 + 0.485111056870881096`\ y2 + 
            1.1033699633699634`\ y3 + 0.31742738589211612`\ y4 == \ 13, \n
        0.088235294117647065`\ y1 + 0.467032967032966972`\ y2 + 
            0.105809128630705373`\ y3 + 1.33999999999999985`\ y4 == \ 9}, 
      \ {y1, y2, y3, y4}]\n\)\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 15.9988452478965896`, y2 \[Rule] 12.2353833115710775`, 
        y3 \[Rule] 4.7539003838979692`, y4 \[Rule] 1.02313713134553396`}}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n
      \t{a0 + a1 + a2 + a3 == \ 15.9988452478965896`, \n\t\t
        a0 + a1/2 - a2/2 - a3 == 12.2353833115710775`, \n\t\t
        a0 - a1/2 - a2/2 + a3 == \ 4.7539003838979692`, \n\t\t
        a0 - a1 + a2 - a3 == \ 1.02313713134553396`}, {a0, a1, a2, a3}]\)], 
  "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 8.50009162836336962`, a1 \[Rule] 7.48573034807472126`, 
        a2 \[Rule] 0.010899561257692385`, a3 \[Rule] 0.00212371020080670547`}}
      \)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{Automatic, 93}, {-5, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 767, 13, 203, "Input"],
Cell[2501, 66, 150, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2688, 73, 685, 12, 171, "Input"],
Cell[3376, 87, 150, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3563, 94, 685, 12, 187, "Input"],
Cell[4251, 108, 148, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4436, 115, 683, 12, 171, "Input"],
Cell[5122, 129, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5308, 136, 684, 10, 267, "Input"],
Cell[5995, 148, 179, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6211, 156, 302, 6, 107, "Input"],
Cell[6516, 164, 188, 3, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

